﻿Imports System.Net.NetworkInformation
Imports System.Net.NetworkInformation.IPAddressInformation
Imports System.Net
Imports System.Management
Imports System.Management.Instrumentation
Imports System.Globalization
Imports System.Net.Sockets
Imports System.Text
Imports System.Security
Imports System.IO
Public Class Form1
    ' written by amgadtamer 24-09-2012
    Private IPAddress As IPAddress
    Private Telsocket As Socket
    Private Endpoint As IPEndPoint
    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        RouterIP()
    End Sub
    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click

        If Not Me.TextBoxsub.Text.Trim = "" Then
            Dim ipaddress As String = Me.TextBoxip.Text.Trim
            Dim subnet As String = Me.TextBoxsub.Text.Trim
            Dim managmentclass As New ManagementClass("Win32_NetworkAdapterConfiguration", New ObjectGetOptions)
            Dim objmoc As ManagementObjectCollection = managmentclass.GetInstances
            For Each objmo As ManagementObject In objmoc
                Dim newip As ManagementBaseObject = Nothing
                Dim setip As ManagementBaseObject = Nothing
                newip = objmo.GetMethodParameters("EnableStatic")
                newip("IPAddress") = New String() {ipaddress}
                newip("SubnetMask") = New String() {subnet}
                setip = objmo.InvokeMethod("EnableStatic", newip, Nothing)
            Next
            Timer1.Start()
        Else
            MsgBox("you must add subnet mask")
        End If

    End Sub
    Function RouterIP() As Boolean
        Dim adapters() As NetworkInterface = NetworkInterface.GetAllNetworkInterfaces
        Dim adaptersettings As IPInterfaceProperties = Nothing
        Dim gateways As GatewayIPAddressInformationCollection = Nothing
        Dim ips As IPAddressInformation = Nothing
        For Each adapter As NetworkInterface In adapters
            adaptersettings = adapter.GetIPProperties
            gateways = adaptersettings.GatewayAddresses
            For Each gateway As GatewayIPAddressInformation In gateways
                If gateway.Address.ToString <> "0.0.0.0" Then
                    Me.ListBoxip.Items.Add(gateway.Address.ToString)
                End If

            Next
        Next
        Return True
    End Function
    Private Sub ListBoxgat_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ListBoxip.SelectedIndexChanged
        If (Me.ListBoxip.SelectedIndices.Count > 0) Then
            Me.TextBoxip.Text = Me.ListBoxip.SelectedItem.ToString
        End If
    End Sub
    Private Function GetStatusString(ByVal status As IPStatus) As String
        Select Case status
            Case IPStatus.Success
                Return "Success."
            Case IPStatus.DestinationHostUnreachable
                Return "Destination host unreachable."
            Case IPStatus.DestinationNetworkUnreachable
                Return "Destination network unreachable."
            Case IPStatus.DestinationPortUnreachable
                Return "Destination port unreachable."
            Case IPStatus.DestinationProtocolUnreachable
                Return "Destination protocol unreachable."
            Case IPStatus.PacketTooBig
                Return "Packet too big."
            Case IPStatus.TtlExpired
                Return "TTL expired."
            Case IPStatus.ParameterProblem
                Return "Parameter problem."
            Case IPStatus.SourceQuench
                Return "Source quench."
            Case IPStatus.TimedOut
                Return "Timed out."
            Case Else
                Return "Ping failed."
        End Select
    End Function
    Dim WithEvents pingClient As New Ping()
    Private Sub Timer1_Tick(sender As System.Object, e As System.EventArgs) Handles Timer1.Tick
        If TextBoxip.Text.Length <> 0 Then

            pingdetailstextbox.Text &= "Pinging " & TextBoxip.Text & " . . ." & Environment.NewLine
            pingClient.SendAsync(TextBoxip.Text, Nothing)
        Else
            MessageBox.Show("Please enter an IP address or host name.")
        End If
    End Sub

    Private Sub pingClient_PingCompleted(ByVal sender As Object, ByVal e As PingCompletedEventArgs) Handles pingClient.PingCompleted
        If e.Error Is Nothing Then
            If e.Cancelled Then
                pingdetailstextbox.Text &= "Ping cancelled." & Environment.NewLine

            Else
                If e.Reply.Status = IPStatus.Success Then
                    pingdetailstextbox.Text &= "  " & e.Reply.Address.ToString() & " " &
                        e.Reply.RoundtripTime.ToString(NumberFormatInfo.CurrentInfo) & "ms " &
  Environment.NewLine
                Else
                    pingdetailstextbox.Text &= "  " & GetStatusString(e.Reply.Status) &
                    Environment.NewLine
                End If
            End If
        Else
            pingdetailstextbox.Text &= "  Ping error." & Environment.NewLine
            MessageBox.Show("An error occurred while sending this ping. " & e.Error.InnerException.Message.ToString())
        End If
    End Sub

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click

        Try

            If Me.ListBoxip.SelectedIndices.Count > 0 Then
                If (Form2.ShowDialog = Windows.Forms.DialogResult.OK) Then
                    RestartRouter(Form2.selectedgateway, 23, Form2.username, Form2.password)
                End If
            End If
        Catch ex As Exception
            MsgBox(ErrorToString)
        End Try
    End Sub

    Sub RestartRouter(ByVal ip As String, ByVal port As Integer, ByVal user As String, ByVal pass As String)
        Dim ns As NetworkStream
        Dim Tclient As New TcpClient(ip, port)
        ns = Tclient.GetStream
        'تأكد من هذا الامر لانه يختلف من مودم لآخر
        Dim Command As String = "sys reboot"
        Dim RecvString As String = String.Empty
        Telsocket = New Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp)
        IPAddress = IPAddress.Parse(ip.Trim)
        Endpoint = New IPEndPoint(IPAddress, port)
        Dim SendBytes As [Byte]() = Encoding.ASCII.GetBytes(Command & vbCrLf)
        Telsocket.Connect(Endpoint)
        Wait(1000)
        Dim username As Byte() = Encoding.ASCII.GetBytes(user & vbCrLf)
        ns.Write(username, 0, username.Length)
        Telsocket.Send(username, username.Length, SocketFlags.None)
        Wait(1000)

        Dim password As Byte() = Encoding.ASCII.GetBytes(pass & vbCrLf)
        ns.Write(password, 0, password.Length)
        Telsocket.Send(password, password.Length, SocketFlags.None)

        Dim RecvBytes(255) As [Byte]
        Dim NumBytes As Integer = 0
        System.Threading.Thread.Sleep(500)
        Wait(1000)

        If Telsocket.Connected Then
            Telsocket.Send(SendBytes, SendBytes.Length, SocketFlags.None)
            Do
                NumBytes = Telsocket.Receive(RecvBytes, RecvBytes.Length, 0)
                RecvString = RecvString + Encoding.ASCII.GetString(RecvBytes, 0, NumBytes)
            Loop While NumBytes = 256
            Me.pingdetailstextbox.Text = RecvString
            Wait(1000)
            Telsocket.Disconnect(False)
            IPAddress = Nothing
            Endpoint = Nothing
            Telsocket = Nothing
            Command = Nothing
            RecvString = Nothing
        
        End If
    End Sub
    ' threed sleep
    Private Sub Wait(ByVal PMillseconds As Integer)
        Dim TimeNow As DateTime
        Dim TimeEnd As DateTime
        Dim StopFlag As Boolean
        TimeEnd = Now()
        TimeEnd = TimeEnd.AddMilliseconds(PMillseconds)
        StopFlag = False
        While Not StopFlag
            TimeNow = Now()
            If TimeNow > TimeEnd Then
                StopFlag = True
            End If
            Application.DoEvents()
        End While
        TimeNow = Nothing
        TimeEnd = Nothing
    End Sub

End Class
